 function c = InterpNj2(x,y)
% c = InterpNj(x,y)
% Njutnov interpolacioni polinom
% x je vrsta vektor 
% y je vrsta vektor vrijednosti funkcije u x
%p(x) = c(1) + c(2)(x-x(1))+...+ c(n)(x-x(1))...(x-x(n-1))
%p(x(i)) = y(i), i=1:n.

n = length(x);
c = zeros(1,n);
c(1) = y(1);
if n > 1
   c(2:n) = InterpNj2(x(2:n),(y(2:n)-y(1))./(x(2:n)-x(1)));
end
